<?php

/**
 * Class that operate on table 'expensetype'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
class ExpensetypeMySqlDAO implements ExpensetypeDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ExpensetypeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM expensetype WHERE expensetypeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM expensetype';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM expensetype ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param expensetype primary key
     */
    public function delete($expensetypeid) {
        $sql = 'DELETE FROM expensetype WHERE expensetypeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($expensetypeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ExpensetypeMySql expensetype
     */
    public function insert($expensetype) {
        $sql = 'INSERT INTO expensetype (expensetypename, expensetypecomment, tempdelete) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($expensetype->expensetypename);
        $sqlQuery->set($expensetype->expensetypecomment);
        $sqlQuery->setNumber($expensetype->tempdelete);

        $id = $this->executeInsert($sqlQuery);
        $expensetype->expensetypeid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ExpensetypeMySql expensetype
     */
    public function update($expensetype) {
        $sql = 'UPDATE expensetype SET expensetypename = ?, expensetypecomment = ?, tempdelete = ? WHERE expensetypeid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($expensetype->expensetypename);
        $sqlQuery->set($expensetype->expensetypecomment);
        $sqlQuery->setNumber($expensetype->tempdelete);

        $sqlQuery->setNumber($expensetype->expensetypeid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM expensetype';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByExpensetypename($value) {
        $sql = 'SELECT * FROM expensetype WHERE expensetypename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpensetypecomment($value) {
        $sql = 'SELECT * FROM expensetype WHERE expensetypecomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTempdelete($value) {
        $sql = 'SELECT * FROM expensetype WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByExpensetypename($value) {
        $sql = 'DELETE FROM expensetype WHERE expensetypename = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpensetypecomment($value) {
        $sql = 'DELETE FROM expensetype WHERE expensetypecomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTempdelete($value) {
        $sql = 'DELETE FROM expensetype WHERE tempdelete = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ExpensetypeMySql
     */
    protected function readRow($row) {
        $expensetype = new Expensetype();

        $expensetype->expensetypeid = isset($row['expensetypeid']) ? $row['expensetypeid'] : '';
        [''];
        $expensetype->expensetypename = isset($row['expensetypename']) ? $row['expensetypename'] : '';
        [''];
        $expensetype->expensetypecomment = isset($row['expensetypecomment']) ? $row['expensetypecomment'] : '';
        [''];
        $expensetype->tempdelete = isset($row['tempdelete']) ? $row['tempdelete'] : '';
        [''];

        return $expensetype;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ExpensetypeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>